/*
 Navicat Premium Data Transfer

 Source Server         : localhost
 Source Server Type    : MySQL
 Source Server Version : 50527
 Source Host           : localhost:33061
 Source Schema         : star

 Target Server Type    : MySQL
 Target Server Version : 50527
 File Encoding         : 65001

 Date: 03/08/2018 13:59:01
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for l_acei
-- ----------------------------
DROP TABLE IF EXISTS `l_acei`;
CREATE TABLE `l_acei`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `DIDSTD` varchar(24) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_arb
-- ----------------------------
DROP TABLE IF EXISTS `l_arb`;
CREATE TABLE `l_arb`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `DIDSTD` varchar(24) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_cat
-- ----------------------------
DROP TABLE IF EXISTS `l_cat`;
CREATE TABLE `l_cat`  (
  `PROVINCE_ID` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVINCE_NAME` varchar(100) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMPHUR_ID` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMPHUR_NAME` varchar(100) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TAMBOL_ID` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TAMBOL_NAME` varchar(100) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  INDEX `PROVINCE_ID`(`PROVINCE_ID`) USING BTREE,
  INDEX `AMPHUR_ID`(`AMPHUR_ID`) USING BTREE,
  INDEX `TAMBOL_ID`(`TAMBOL_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_catm
-- ----------------------------
DROP TABLE IF EXISTS `l_catm`;
CREATE TABLE `l_catm`  (
  `PROVINCE_NAME` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMPHUR_NAME` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVINCE_ID` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMPHUR_ID` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  INDEX `PROVINCE_ID`(`PROVINCE_ID`) USING BTREE,
  INDEX `AMPHUR_ID`(`AMPHUR_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_chronic
-- ----------------------------
DROP TABLE IF EXISTS `l_chronic`;
CREATE TABLE `l_chronic`  (
  `CODE` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NOT NULL DEFAULT '',
  `DESC_E` varchar(250) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DESC_T` varchar(250) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DMHT` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATEEXPIRE` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`CODE`) USING BTREE,
  INDEX `CODE`(`CODE`) USING BTREE,
  INDEX `DMHT`(`DMHT`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_config_center
-- ----------------------------
DROP TABLE IF EXISTS `l_config_center`;
CREATE TABLE `l_config_center`  (
  `ROWID` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `HOST` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DATABASENAME` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PORT` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `USERNAME` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PASSWORD` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `AMOUNT` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_confighcode
-- ----------------------------
DROP TABLE IF EXISTS `l_confighcode`;
CREATE TABLE `l_confighcode`  (
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOSPNAME` varchar(200) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVINCE_ID` varchar(4) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVINCE_NAME` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMPHUR_ID` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMPHUR_NAME` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HMAIN` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HMAIN_NAME` varchar(100) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `LATITUDE` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `LONGITUDE` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DRUG_STORE` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HNPID` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TEL` varchar(100) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DRUG_LABEL` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `VERSION` varchar(100) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `506ONLINE` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `WEB506` varchar(100) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USERNAME` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PASSWORD` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `WEB506_2` varchar(100) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HSERV` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `BILL` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_drug
-- ----------------------------
DROP TABLE IF EXISTS `l_drug`;
CREATE TABLE `l_drug`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `DIDSTD` varchar(24) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_education
-- ----------------------------
DROP TABLE IF EXISTS `l_education`;
CREATE TABLE `l_education`  (
  `EDUCATION_CODE` char(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NOT NULL DEFAULT '',
  `EDUCATION_DESC_FULL` varchar(250) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `EDUCATION_DESC` varchar(200) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`EDUCATION_CODE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_hospitals
-- ----------------------------
DROP TABLE IF EXISTS `l_hospitals`;
CREATE TABLE `l_hospitals`  (
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NOT NULL DEFAULT '',
  `HOSPNAME` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVINCE_ID` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMP` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TAM` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `MOO` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`HOSPCODE`) USING BTREE,
  INDEX `HOSPCODE`(`HOSPCODE`) USING BTREE,
  INDEX `HOSPNAME`(`HOSPNAME`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_instype_new
-- ----------------------------
DROP TABLE IF EXISTS `l_instype_new`;
CREATE TABLE `l_instype_new`  (
  `INSTYPE_CODE` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `INSTYPE_DESC` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `INSTYPE_TYPE` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `INSTYPE_NAME` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `INSTYPE_TYPE2` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `INSTYPE_NAME2` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  INDEX `CODE`(`INSTYPE_CODE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_occupation
-- ----------------------------
DROP TABLE IF EXISTS `l_occupation`;
CREATE TABLE `l_occupation`  (
  `OCCUPATION_CODE` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `OCCUPATION_DESC` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `OLD_CODE` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  INDEX `occu_code`(`OCCUPATION_CODE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_occupation_old
-- ----------------------------
DROP TABLE IF EXISTS `l_occupation_old`;
CREATE TABLE `l_occupation_old`  (
  `OCCUPATION_CODE` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `OCCUPATION_DESC` varchar(100) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `OCCUPATION_506` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_prename
-- ----------------------------
DROP TABLE IF EXISTS `l_prename`;
CREATE TABLE `l_prename`  (
  `PRENAME_CODE` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PRENAME` varchar(200) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PRENAME_DESC` varchar(200) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `INT_CODE` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEX` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  INDEX `PRENAME_CODE`(`PRENAME_CODE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_unit
-- ----------------------------
DROP TABLE IF EXISTS `l_unit`;
CREATE TABLE `l_unit`  (
  `UNIT_CODE` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `UNIT_DESC` varchar(100) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  INDEX `UNIT_CODE`(`UNIT_CODE`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for l_user
-- ----------------------------
DROP TABLE IF EXISTS `l_user`;
CREATE TABLE `l_user`  (
  `USER_ID` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NOT NULL DEFAULT '',
  `CID` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PRENAME` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `FNAME` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `LNAME` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USERNAME` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PASSWORD` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `ADMIN` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`USER_ID`) USING BTREE,
  INDEX `USER_ID`(`USER_ID`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_address
-- ----------------------------
DROP TABLE IF EXISTS `m_address`;
CREATE TABLE `m_address`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `ADDRESSTYPE` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOUSE_ID` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOUSETYPE` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `ROOMNO` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CONDO` varchar(75) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOUSENO` varchar(75) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SOISUB` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SOIMAIN` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `ROAD` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `VILLANAME` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `VILLAGE` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TAMBON` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMPUR` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CHANGWAT` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TELEPHONE` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `MOBILE` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_baseline
-- ----------------------------
DROP TABLE IF EXISTS `m_baseline`;
CREATE TABLE `m_baseline`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CID` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WEIGHT` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `HEIGHT` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DATE_RECORD` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DATE_START` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_card
-- ----------------------------
DROP TABLE IF EXISTS `m_card`;
CREATE TABLE `m_card`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `INSTYPE_OLD` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `INSTYPE_NEW` varchar(4) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `INSID` varchar(18) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STARTDATE` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `EXPIREDATE` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `MAIN` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SUB` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE,
  INDEX `INSID`(`INSID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_chronic
-- ----------------------------
DROP TABLE IF EXISTS `m_chronic`;
CREATE TABLE `m_chronic`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATE_DIAG` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CHRONIC` varchar(6) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOSP_DX` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOSP_RX` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATE_DISCH` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TYPEDISCH` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `CHRONIC`(`CHRONIC`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `DATE_DIAG`(`DATE_DIAG`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_chronicfu
-- ----------------------------
DROP TABLE IF EXISTS `m_chronicfu`;
CREATE TABLE `m_chronicfu`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEQ` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATE_SERV` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `WEIGHT` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HEIGHT` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `WAIST_CM` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SBP` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DBP` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `FOOT` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `RETINA` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVIDER` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `SEQ`(`SEQ`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `DATE_SERV`(`DATE_SERV`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_cid
-- ----------------------------
DROP TABLE IF EXISTS `m_cid`;
CREATE TABLE `m_cid`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `CID` varchar(13) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HN` varchar(16) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_DATA` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(16) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_drug_ipd
-- ----------------------------
DROP TABLE IF EXISTS `m_drug_ipd`;
CREATE TABLE `m_drug_ipd`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AN` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATETIME_ADMIT` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `WARDSTAY` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TYPEDRUG` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DIDSTD` varchar(24) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DNAME` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATESTART` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATEFINISH` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMOUNT` varchar(12) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `UNIT` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `UNIT_PACKING` varchar(20) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DRUGPRICE` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DRUGCOST` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVIDER` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `AN`(`AN`) USING BTREE,
  INDEX `DATETIME_ADMIT`(`DATETIME_ADMIT`) USING BTREE,
  INDEX `DIDSTD`(`DIDSTD`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_drug_opd
-- ----------------------------
DROP TABLE IF EXISTS `m_drug_opd`;
CREATE TABLE `m_drug_opd`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEQ` varchar(16) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATE_SERV` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CLINIC` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DIDSTD` varchar(24) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DNAME` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMOUNT` varchar(12) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `UNIT` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `UNIT_PACKING` varchar(20) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DRUGPRICE` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DRUGCOST` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVIDER` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `SEQ`(`SEQ`) USING BTREE,
  INDEX `DATE_SERV`(`DATE_SERV`) USING BTREE,
  INDEX `DIDSTD`(`DIDSTD`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `CLINIC`(`CLINIC`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_evaluate
-- ----------------------------
DROP TABLE IF EXISTS `m_evaluate`;
CREATE TABLE `m_evaluate`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CID` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_DM` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_HT` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_GLO` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_OBS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_CYS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_CHRO` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_UN` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_DM` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_HT` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_CVA` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_CIR` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_HIV` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_GOUT` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_CARDIO` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_CA` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_SLE` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `COX` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_home
-- ----------------------------
DROP TABLE IF EXISTS `m_home`;
CREATE TABLE `m_home`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HID` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOUSE_ID` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOUSETYPE` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `ROOMNO` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CONDO` varchar(75) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOUSE` varchar(75) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SOISUB` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SOIMAIN` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `ROAD` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `VILLANAME` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `VILLAGE` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TAMBON` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMPUR` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CHANGWAT` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TELEPHONE` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `LATITUDE` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `LONGITUDE` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `NFAMILY` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `LOCATYPE` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `VHVID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HEADID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TOILET` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `WATER` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `WATERTYPE` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `GARBAGE` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOUSING` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DURABILITY` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CLEANLINESS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `VENTILATION` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `LIGHT` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `WATERTM` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `MFOOD` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `BCONTROL` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `ACONTROL` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CHEMICAL` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `OUTDATE` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `HOSPCODE`(`HOSPCODE`) USING BTREE,
  INDEX `HID`(`HID`) USING BTREE,
  INDEX `VILLAGE`(`VILLAGE`) USING BTREE,
  INDEX `TAMBON`(`TAMBON`) USING BTREE,
  INDEX `AMPUR`(`AMPUR`) USING BTREE,
  INDEX `CHANGWAT`(`CHANGWAT`) USING BTREE,
  INDEX `HOUSE`(`HOUSE`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_intervention
-- ----------------------------
DROP TABLE IF EXISTS `m_intervention`;
CREATE TABLE `m_intervention`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CID` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DATE_START` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `INTERVENTION` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DATE_RESULT` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RESULT` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `REMARK` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_labfu
-- ----------------------------
DROP TABLE IF EXISTS `m_labfu`;
CREATE TABLE `m_labfu`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEQ` varchar(16) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATE_SERV` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `LABTEST` varchar(7) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `LABRESULT` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVIDER` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `SEQ`(`SEQ`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `DATE_SERV`(`DATE_SERV`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_person
-- ----------------------------
DROP TABLE IF EXISTS `m_person`;
CREATE TABLE `m_person`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `HID` varchar(14) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PRENAME` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LNAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `HN` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SEX` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BIRTH` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MSTATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OCCUPATION_OLD` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OCCUPATION_NEW` varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RACE` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NATION` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RELIGION` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EDUCATION` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FSTATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FATHER` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MOTHER` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `COUPLE` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VSTATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MOVEIN` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DISCHARGE` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DDISCHARGE` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ABOGROUP` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RHGROUP` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LABOR` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PASSPORT` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TYPEAREA` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `USER_REC` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  INDEX `HOSPCODE`(`HOSPCODE`) USING BTREE,
  INDEX `CID`(`CID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `HID`(`HID`) USING BTREE,
  INDEX `DISCHARGE`(`DISCHARGE`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `NAME`(`NAME`) USING BTREE,
  INDEX `LNAME`(`LNAME`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for m_service
-- ----------------------------
DROP TABLE IF EXISTS `m_service`;
CREATE TABLE `m_service`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HN` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEQ` varchar(16) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATE_SERV` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TIME_SERV` varchar(6) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `LOCATION` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `INTIME` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `INSTYPE` varchar(4) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `INSID` varchar(18) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `MAIN` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TYPEIN` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `REFERINHOSP` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CAUSEIN` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CHIEFCOMP` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SERVPLACE` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `BTEMP` varchar(4) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SBP` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DBP` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PR` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `RR` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TYPEOUT` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `REFEROUTHOSP` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CAUSEOUT` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `COST` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PRICE` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PAYPRICE` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `ACTUALPAY` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `SEQ`(`SEQ`) USING BTREE,
  INDEX `CHIEFCOMP`(`CHIEFCOMP`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `DATE_SERV`(`DATE_SERV`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for r_log
-- ----------------------------
DROP TABLE IF EXISTS `r_log`;
CREATE TABLE `r_log`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `USER_REC` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for star_address
-- ----------------------------
DROP TABLE IF EXISTS `star_address`;
CREATE TABLE `star_address`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `ADDRESSTYPE` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOUSE_ID` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOUSETYPE` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `ROOMNO` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CONDO` varchar(75) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HOUSENO` varchar(75) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SOISUB` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SOIMAIN` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `ROAD` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `VILLANAME` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `VILLAGE` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TAMBON` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMPUR` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CHANGWAT` varchar(2) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TELEPHONE` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `MOBILE` varchar(10) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for star_baseline
-- ----------------------------
DROP TABLE IF EXISTS `star_baseline`;
CREATE TABLE `star_baseline`  (
  `ROWID` int(11) NULL DEFAULT NULL,
  `HOSPCODE` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CID` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `WEIGHT` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `HEIGHT` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DATE_RECORD` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DATE_START` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for star_chronicfu
-- ----------------------------
DROP TABLE IF EXISTS `star_chronicfu`;
CREATE TABLE `star_chronicfu`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEQ` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATE_SERV` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `WEIGHT` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `HEIGHT` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `WAIST_CM` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SBP` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DBP` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `FOOT` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `RETINA` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVIDER` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `SEQ`(`SEQ`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `DATE_SERV`(`DATE_SERV`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for star_drug_ipd
-- ----------------------------
DROP TABLE IF EXISTS `star_drug_ipd`;
CREATE TABLE `star_drug_ipd`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AN` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATETIME_ADMIT` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `WARDSTAY` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `TYPEDRUG` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DIDSTD` varchar(24) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DNAME` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATESTART` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATEFINISH` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMOUNT` varchar(12) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `UNIT` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `UNIT_PACKING` varchar(20) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DRUGPRICE` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DRUGCOST` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVIDER` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `AN`(`AN`) USING BTREE,
  INDEX `DATETIME_ADMIT`(`DATETIME_ADMIT`) USING BTREE,
  INDEX `DIDSTD`(`DIDSTD`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for star_drug_opd
-- ----------------------------
DROP TABLE IF EXISTS `star_drug_opd`;
CREATE TABLE `star_drug_opd`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEQ` varchar(16) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATE_SERV` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `CLINIC` varchar(5) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DIDSTD` varchar(24) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DNAME` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `AMOUNT` varchar(12) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `UNIT` varchar(3) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `UNIT_PACKING` varchar(20) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DRUGPRICE` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DRUGCOST` varchar(11) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVIDER` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(255) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `SEQ`(`SEQ`) USING BTREE,
  INDEX `DATE_SERV`(`DATE_SERV`) USING BTREE,
  INDEX `DIDSTD`(`DIDSTD`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `CLINIC`(`CLINIC`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for star_evaluate
-- ----------------------------
DROP TABLE IF EXISTS `star_evaluate`;
CREATE TABLE `star_evaluate`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CID` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_DM` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_HT` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_GLO` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_OBS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_CYS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_CHRO` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RF_UN` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_DM` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_HT` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_CVA` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_CIR` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_HIV` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_GOUT` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_CARDIO` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_CA` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CO_SLE` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `COX` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for star_intervention
-- ----------------------------
DROP TABLE IF EXISTS `star_intervention`;
CREATE TABLE `star_intervention`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CID` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DATE_START` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `INTERVENTION` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DATE_RESULT` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RESULT` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `REMARK` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for star_labfu
-- ----------------------------
DROP TABLE IF EXISTS `star_labfu`;
CREATE TABLE `star_labfu`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEQ` varchar(16) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `DATE_SERV` varchar(8) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `LABTEST` varchar(7) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `LABRESULT` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `PROVIDER` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `USER_REC` varchar(50) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET tis620 COLLATE tis620_thai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`ROWID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `SEQ`(`SEQ`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `DATE_SERV`(`DATE_SERV`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = tis620 COLLATE = tis620_thai_ci ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for star_person
-- ----------------------------
DROP TABLE IF EXISTS `star_person`;
CREATE TABLE `star_person`  (
  `ROWID` int(11) NOT NULL AUTO_INCREMENT,
  `HOSPCODE` varchar(9) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `CID` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PID` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `HID` varchar(14) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PRENAME` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LNAME` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `HN` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SEX` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `BIRTH` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MSTATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OCCUPATION_OLD` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `OCCUPATION_NEW` varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RACE` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `NATION` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RELIGION` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `EDUCATION` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FSTATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `FATHER` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MOTHER` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `COUPLE` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `VSTATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `MOVEIN` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DISCHARGE` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `DDISCHARGE` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ABOGROUP` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `RHGROUP` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `LABOR` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `PASSPORT` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `TYPEAREA` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `D_UPDATE` varchar(14) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `USER_REC` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `STATUS_AF` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `SEND_STATUS` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  INDEX `HOSPCODE`(`HOSPCODE`) USING BTREE,
  INDEX `CID`(`CID`) USING BTREE,
  INDEX `PID`(`PID`) USING BTREE,
  INDEX `HID`(`HID`) USING BTREE,
  INDEX `DISCHARGE`(`DISCHARGE`) USING BTREE,
  INDEX `STATUS_AF`(`STATUS_AF`) USING BTREE,
  INDEX `NAME`(`NAME`) USING BTREE,
  INDEX `LNAME`(`LNAME`) USING BTREE,
  INDEX `ROWID`(`ROWID`) USING BTREE,
  INDEX `D_UPDATE`(`D_UPDATE`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Compact;

SET FOREIGN_KEY_CHECKS = 1;
